<?php
/*
Plugin Name: Ufathom Text Links
Plugin URI: http://www.ufathom.com/
Description: This plugin lets you display related Ufathom projects below every posts.
Author: Ufathom
Version: 1.1
Author URI: http://www.ufathom.com/
*/

/*  Copyright 2009  Ufathom  (email : ufathom@gmail.com )

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

*/


add_filter("the_content","ufathom_project");
add_action("admin_menu","ufathom_add_to_admin");

function ufathom_add_to_admin() {
    add_options_page('Ufathom Text Link Options', 'Ufathom Text Link Settings', 'administrator', 'ufathom-project', 'ufathom_options');
}

function ufathom_options() {
    echo "<h2>Ufathom Text Link Settings</h2><br>";
    if(!empty($_POST['username'])) {
        update_option("ufathom_username",$_POST['username']);
        echo "<div class=\"updated\"><b>Options Updated!</b></div><br><br><br>";
    }

    $username = get_option("ufathom_username");
    echo "<div class=\"wrap\"><form action=\"\" method=\"post\">";
    echo "<b>Your Ufathom Username: </b><input type=\"text\" name=\"username\" value=\"{$username}\">";
    echo " <input type=\"submit\" value=\"Update\">";
    echo "</form><br><br>";
    echo "<a href=\"http://www.ufathom.com/login/register.html\" target=\"_blank\">Get an account!</a><br><br>";
    echo "</div>";

}


function getUfathomAffLink($keyword) {
    $contents = file_get_contents("http://www.ufathom.com/api/project/Search.json?keyword={$keyword}");
    $username = get_option("ufathom_username");
    if(empty($username)) { $username = "manas"; }
    $UFATHOM = json_decode($contents,true);
    //foreach($UFATHOM['project']['items'] as $k => $v) { echo $k."-".$v."\n";}
    $retval = "<br><br><b>Related Projects on Ufathom:</b><br>";
    if( count($UFATHOM['project']['items']) > 0) {
        $retval .= "<ul>";
        $count = count($UFATHOM['project']['items']);
        if($count > 10) { $count = 10; }
        for($i=0;$i < $count; $i++) {
            $id = $UFATHOM['project']['items'][$i]['id'];
            $name = $UFATHOM['project']['items'][$i]['name'];
            $retval .= "<li><a href=\"http://www.ufathom.com/projects/{$username}_{$id}.html\" target=\"_blank\">{$name}</a></li>";
        }
        $retval .= "</ul>";
    } else {
        $retval .= "No related projects found on Ufathom :(";

    }

    return $retval;
}

function ufathom_project($content) {
    global $post,$page, $pages;
    $context = join(",",explode(" ",$post->post_title.' '.$pages[$page-1]));
    $UFATHOM_Links = getUfathomAffLink($context);
    $content .= "<br><br>".$UFATHOM_Links."<br><br>";
    return $content;

}
?>
